/*
 * PushEffectInfo.h
 *
 * Created 9/14/2009 By Johnny Huynh
 *
 * Version 00.00.01 9/14/2009
 *
 * Copyright Information:
 * All content copyright  2009 Johnny Huynh. All rights reserved.
 */
 
 #ifndef PUSH_BACK_EFFECT_INFO_H
 #define PUSH_BACK_EFFECT_INFO_H
 
 template <typename T> class PushBackEffectInfo;
 
 #include "global.h"
 
 #include "collisionEntry.h"
 #include "EffectInfo.h"
 #include "EffectTask.h"
 #include "pointerTo.h"
 
 #include "PushInfo.h"
 #include "StraightMoveEffectInfo.h"
 #include "StunEffectInfo.h"
 
 /**
  * Class specification for PushBackEffectInfo
  */
 template <typename T>
 class PushBackEffectInfo : public StraightMoveEffectInfo<T>, public StunEffectInfo<T>
 {
 // Protected Static Functions
 protected:
    static inline void process_push_back_effect( EffectInfo<T>* effect_info_Ptr, Object<T>* into_object_Ptr, const CollisionEntry& c_entry );
 
 // Data Members
 private:
    
 // Local Functions
 public:
    PushBackEffectInfo( const double stun_duration, const T move_distance, const double move_duration, EffectFunc* effect_func = &PushBackEffectInfo<T>::process_push_back_effect );
    PushBackEffectInfo( const PushBackEffectInfo<T>& push_back_effect_info );
    virtual ~PushBackEffectInfo();
    inline PushBackEffectInfo<T>& operator=( const PushBackEffectInfo<T>& push_back_effect_info );
 
 // Private Functions
 private:
    
 // Public Static Functions
 public:
    
 };
 
 /** PROTECTED STATIC FUNCTIONS **/
 
 /**
  * process_push_back_effect() applies the specified push back effect pointed to onto the specified object pointed to.
  * The effect_info_Ptr must be a pointer to a PushBackEffectInfo.
  *
  * @param (EffectInfo<T>*) effect_info_Ptr
  * @param (Object<T>*) into_object_Ptr
  * @param (const CollisionEntry&) c_entry
  */
 template <typename T>
 inline void PushBackEffectInfo<T>::process_push_back_effect( EffectInfo<T>* effect_info_Ptr, Object<T>* into_object_Ptr, 
                                                              const CollisionEntry& c_entry )
 {  
    nassertv( effect_info_Ptr != NULL );
    nassertv( into_object_Ptr != NULL );
    
    StraightMoveEffectInfo<T>::process_straight_move_back_effect( effect_info_Ptr, into_object_Ptr, c_entry );
    StunEffectInfo<T>::process_stun_effect( effect_info_Ptr, into_object_Ptr, c_entry );
 }
 
 /** LOCAL FUNCTIONS **/
 
 /**
  * Constructor
  */
 template <typename T>
 PushBackEffectInfo<T>::PushBackEffectInfo( const double stun_duration, 
                                            const T move_distance, const double move_duration,
                                            EffectFunc* effect_func )
                       : StraightMoveEffectInfo<T>( move_distance, move_duration, effect_func ),
                         StunEffectInfo<T>( stun_duration, effect_func ),
                         EffectInfo<T>( effect_func )
 {
    
 }
 
 /**
  * Copy Constructor
  */
 template <typename T>
 PushBackEffectInfo<T>::PushBackEffectInfo( const PushBackEffectInfo<T>& push_back_effect_info )
                       : StraightMoveEffectInfo<T>( push_back_effect_info ),
                         StunEffectInfo<T>( push_back_effect_info ),
                         EffectInfo<T>( push_back_effect_info )
 {
    
 }
 
 /**
  * Destructor
  */
 template <typename T>
 PushBackEffectInfo<T>::~PushBackEffectInfo()
 {
    
 }
 
 /**
  * operator=() copies the content of the specified PushBackEffectInfo to this PushBackEffectInfo.
  *
  * @param (const PushBackEffectInfo<T>&) push_back_effect_info
  * @return PushBackEffectInfo<T>&
  */
 template <typename T>
 inline PushBackEffectInfo<T>& PushBackEffectInfo<T>::operator=( const PushBackEffectInfo<T>& push_back_effect_info )
 {
    StraightMoveEffectInfo<T>::operator=( push_back_effect_info );
    StunEffectInfo<T>::operator=( push_back_effect_info );
    
    return *this;
 }
 
 #endif // PUSH_BACK_EFFECT_INFO_H